#!/usr/bin/python
from rgbkbd.core import Monochrome, KeyboardMode
from rgbkbd.color import Colors
from rgbkbd.animation import AngleMotionPattern, MotionAnimation

# Keyboard Mode
def AngleMotionMode(manager, keyboard, colors=(Colors.WHITE, Colors.BLACK),
        period=5, color_pattern_cls=None, angle=0.0, size=50):
    """Keyboard mode to apply a color pattern with a linear motion"""
    color_pattern = color_pattern_cls(colors=colors, period=period)
    motion_pattern = AngleMotionPattern(angle=angle, size=size, period=period)
    animation = MotionAnimation(keyboard=keyboard, color_pattern=color_pattern,
        motion_pattern=motion_pattern)
    return KeyboardMode(manager, keyboard,
        static_lighting=Monochrome(keyboard, color=colors[-1]),
        animations=[animation])
