#!/usr/bin/python
from rgbkbd.core import Monochrome, KeyboardMode
from rgbkbd.color import Color, Colors
from rgbkbd.animation import RandomAnimation, ColorAnimation

# Keyboard Modes
def StaticMode(manager, keyboard, foreground=Colors.WHITE,
        background=Colors.BLACK):
    return KeyboardMode(manager, keyboard,
        static_lighting=Monochrome(keyboard, color=foreground),
        animations=[])


def RandomMode(manager, keyboard, foreground=None, background=None):
    """Keyboard mode for RandomAnimation"""
    if foreground is None:
        foreground = Color.random8(exclude=background)
    if background is None:
        background = Color.random8(exclude=foreground)

    return KeyboardMode(manager, keyboard,
        static_lighting=Monochrome(keyboard, color=background),
        animations=[
            RandomAnimation(foreground=foreground, background=background, keyboard=keyboard),
        ])


def ColorMode(manager, keyboard, colors=(Colors.WHITE, Colors.BLACK),
        period=5, color_pattern_cls=None):
    """Keyboard mode to apply a stationary color pattern"""
    color_pattern = color_pattern_cls(colors=colors, period=period)
    animation = ColorAnimation(keyboard=keyboard, color_pattern=color_pattern)
    return KeyboardMode(manager, keyboard,
        static_lighting=Monochrome(keyboard, color=colors[-1]),
        animations=[animation])
